<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Site;

class Payment extends Model
{
    protected $fillable = [
        'site_id',
        'reference_id',
        'razorpay_order_id',
        'razorpay_payment_id',
        'amount',
        'currency',
        'status',
        'customer_email',
        'customer_phone',
        'success_url',
        'fail_url',
    ];

    public function site()
    {
        return $this->belongsTo(Site::class);
    }
}
